﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace QQGroupVerificationByWindowsApi
{
    public class WindownApiVerification
    {
        [DllImport("user32.dll", EntryPoint = "FindWindow")]
        private static extern IntPtr FindWindow(string IpClassName, string IpWindowName);
        /// <summary>
        /// 找到句柄
        /// </summary>
        /// <param name="IpClassName">类名</param>
        /// <returns></returns>
        public static IntPtr GetHandle(string IpClassName, string IpWindowName)
        {
            return FindWindow(IpClassName, IpWindowName);

        }
        /// <summary>
        /// 判断是否打开了某指定的QQ群
        /// </summary>
        /// <param name="qqGroupName">参数是群名</param>
        /// <returns></returns>
        public static bool IsInQQGroup(string qqGroupName) 
        {
            IntPtr result = GetHandle("TXGuiFoundation", qqGroupName);
            if (result == IntPtr.Zero)
            {
                return false;
            }
            return true;
        }
    }
}
