﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WindowsUpdateDelay.Common
{
    internal class RegeditUtil
    {
        public static void DelayWindowsUpdate(uint days)
        {
            //计算机\HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\WindowsUpdate\UX\Settings
            //要在 windows 更新中，手动点击下暂停更新，注册表中才会出现下面三个项
            //PauseFeatureUpdatesEndTime,PauseQualityUpdatesEndTime,PauseUpdatesExpiryTime
            //字符串类型，时间格式 2025-02-09T021:56:56Z
            DateTime dateTime = DateTime.Now.AddDays(days);
            string strDate = dateTime.ToString("yyyy-MM-ddTHH:mm:ssZ");
            RegistryKey? reg = Registry.LocalMachine.OpenSubKey("SOFTWARE\\Microsoft\\WindowsUpdate\\UX\\Settings", true);
            reg = reg ?? Registry.LocalMachine.CreateSubKey("SOFTWARE\\Microsoft\\WindowsUpdate\\UX\\Settings", true);
            if (reg != null)
            {
                reg.SetValue("PauseFeatureUpdatesEndTime", strDate);
                reg.SetValue("PauseQualityUpdatesEndTime", strDate);
                reg.SetValue("PauseUpdatesExpiryTime", strDate);
                reg.Close();
            }
        }
    }
}
